//
//  Simple_TableViewController.m
//  Simple Table
//
//  Created by Robert Górczyński on 11-06-28.
//

#import "Simple_TableViewController.h"

@implementation Simple_TableViewController
@synthesize listData; 

- (void)viewDidLoad { 
    NSArray *array = [[NSArray alloc] initWithObjects:@"Niebo", @"Lawenda", 
					  @"Goździk", @"Lukrecja", @"Śnieg", @"Łosoś", @"Banan", @"Roślinność", 
					  @"Lód", @"Orchidea", @"Granit", @"Rtęć", @"Mandarynka", @"Limonka", @"Winogrona", 
					  @"Truskawki", @"Wolfram", @"Srebrny", @"Wiosna", @"Purpurowy", nil]; 
    self.listData = array; 
    [array release]; 
    [super viewDidLoad]; 
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.listData = nil; 
    [super viewDidUnload];
}


- (void)dealloc {
    [listData release]; 
    [super dealloc];
}

#pragma mark - 
#pragma mark Metody źródła danych dla Table View
- (NSInteger)tableView:(UITableView *)tableView 
 numberOfRowsInSection:(NSInteger)section { 
    return [self.listData count]; 
} 

- (UITableViewCell *)tableView:(UITableView *)tableView 
		 cellForRowAtIndexPath:(NSIndexPath *)indexPath {
	
    static NSString *SimpleTableIdentifier = @"SimpleTableIdentifier"; 
	
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier: 
							 SimpleTableIdentifier]; 
    if (cell == nil) { 
        cell = [[[UITableViewCell alloc] 
				 initWithStyle:UITableViewCellStyleDefault 
				 reuseIdentifier:SimpleTableIdentifier] autorelease]; 
    } 
	
	UIImage *image = [UIImage imageNamed:@"star.png"]; 
    cell.imageView.image = image; 

    NSUInteger row = [indexPath row]; 
    cell.textLabel.text = [listData objectAtIndex:row];
    cell.textLabel.font = [UIFont boldSystemFontOfSize:50]; 
	
	if (row < 7) 
        cell.detailTextLabel.text = @"Opis 1"; 
    else 
        cell.detailTextLabel.text = @"Opis 2";
	
    return cell; 
}

#pragma mark - 
#pragma mark Metody delegata tabeli

- (NSInteger)tableView:(UITableView *)tableView 
indentationLevelForRowAtIndexPath:(NSIndexPath *)indexPath { 
    NSUInteger row = [indexPath row]; 
    return row; 
}

- (NSIndexPath *)tableView:(UITableView *)tableView 
 willSelectRowAtIndexPath:(NSIndexPath *)indexPath { 
    NSUInteger row = [indexPath row]; 
	
    if (row == 0) 
        return nil; 
	
    return indexPath; 
}

- (void)tableView:(UITableView *)tableView 
didSelectRowAtIndexPath:(NSIndexPath *)indexPath { 
    NSUInteger row = [indexPath row]; 
    NSString *rowValue = [listData objectAtIndex:row]; 
	
    NSString *message = [[NSString alloc] initWithFormat: 
						 @"Wybrałeś %@", rowValue]; 
    UIAlertView *alert = [[UIAlertView alloc] 
						  initWithTitle:@"Rekord został wybrany!" 
						  message:message 
						  delegate:nil 
						  cancelButtonTitle:@"Tak, wybrałem" 
						  otherButtonTitles:nil]; 
    [alert show]; 
	
    [message release]; 
    [alert release]; 
    [tableView deselectRowAtIndexPath:indexPath animated:YES]; 
}

- (CGFloat)tableView:(UITableView *)tableView 
heightForRowAtIndexPath:(NSIndexPath *)indexPath { 
    return 70; 
}

@end
